<?php
if (!isset($percheck) || empty($percheck) || $percheck != 'vipsystem') { die('Access Denied'); }

// This Data Only For Install - Dont Edit This
function plugin_data()
{
	return array(
		"type" 			=> "payment",
		"name_fa" 		=> "پرداخت از طریق درگاه نام سایت شما",
		"name_en" 		=> "Payment Via paymentCc Gateway",
		"merchantid" 	=> "XXXXXXXXXXXXXXXX-XXXX-XXXX-XXXX-XXXX",
		"sandbox" 		=> 0,
	);
}

function payment_start($id, $price, $usd)
{
    global $CONF, $lang, $site;

	$MerchantID 	= ($site->plugin('paymentcc', 'sandbox') == 1) ? 'sandbox' : $site->plugin('paymentcc', 'merchantid');
	$Description 	= "Payment ID {$id}";
	$Email 			= "";
	$Mobile 		= "";
	$CallbackURL 	= $CONF['site_url'] .'/?callback='. $id;

	$curl = curl_init();
	curl_setopt($curl, CURLOPT_URL, 'http://pay.akil.ir/webservice/rest/PaymentRequest');
	curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type' => 'application/json'));
	curl_setopt($curl, CURLOPT_POSTFIELDS, "MerchantID={$MerchantID}&Amount={$price}&InvoiceID={$id}&Description={$Description}&Email={$Email}&Mobile={$Mobile}&CallbackURL=". urlencode($CallbackURL));
	curl_setopt($curl, CURLOPT_TIMEOUT, 30);
	curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
	$curl_exec = curl_exec($curl);
	curl_close($curl);

	$result = json_decode($curl_exec);

	if (isset($result->Status) && $result->Status == 100)
	{		
		// Save au To Database
		payment_update_au($id, $result->Authority);

		redirect($result->PaymentUrl);
	} else {
		return msg($result->Status, 'danger', $lang['PAYMENT_BOLD']);
	}
}

function payment_verify($id, $price, $usd)
{
    global $site;

	$MerchantID = ($site->plugin('paymentcc', 'sandbox') == 1) ? 'sandbox' : $site->plugin('paymentcc', 'merchantid');

	if (isset($_POST['PaymentStatus']) && $_POST['PaymentStatus'] == 'OK')
	{
		$Authority 	= (isset($_POST['Authority']) && $_POST['Authority'] != "") ? $_POST['Authority'] : "";
		$InvoiceID 	= (isset($_POST['InvoiceID']) && $_POST['InvoiceID'] != "") ? $_POST['InvoiceID'] : "";

		$curl = curl_init();
		curl_setopt($curl, CURLOPT_URL, 'http://pay.akil.ir/webservice/rest/PaymentVerification');
		curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type' => 'application/json'));
		curl_setopt($curl, CURLOPT_POSTFIELDS, "MerchantID={$MerchantID}&Amount={$price}&Authority={$Authority}");
		curl_setopt($curl, CURLOPT_TIMEOUT, 30);
		curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		$curl_exec = curl_exec($curl);
		curl_close($curl);

		$result = json_decode($curl_exec);

		if (isset($result->Status) && $result->Status == 100)
		{
			// Transaction Successful
			return array(
				'status' 		=> 1,
				'id' 			=> $id,
				'callback_ref' 	=> $result->RefID,
				'callback_res' 	=> $result->Status
			);
		} else {
			// Transaction Failed
			return array(
				'status' 		=> 0,
				'id' 			=> 0,
				'callback_ref' 	=> 0,
				'callback_res' 	=> $result->Status
			);
		}
	} else {
		// Transaction Failed
		return array(
			'status' 		=> 0,
			'id' 			=> 0,
			'callback_ref' 	=> 0,
			'callback_res' 	=> 'Transaction Canceled By User'
		);
	}
}
?>